/*------------------------------------------------------------------------------*
 * File Name:	TemplateLibrary.c				 								*
 * Creation: 	12/15/2001														*
 * Purpose: OriginC Source C file												*
 * Copyright (c) OriginLab Corp.	2001										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Kenny 08/25/2009 QA81-14203 RESET_PAGE_NAME_IF_CREATED_FROM_OC				*
 *------------------------------------------------------------------------------*/
#include <data.h>
#include <page.h>
#include <utilities.h>

////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////////
//
/**
		Opens a graph template and extracts an object "templatepict" if it exists.
	Example:
		OpenTemplate(Line);
	Return:
		1 for success extracting to templatepict.
*/
double	openTemplate(string template)
{
	double			isValid;
	GraphPage		grph;
	/// Kenny 08/25/2009 QA81-14203 RESET_PAGE_NAME_IF_CREATED_FROM_OC
	//int				nOption = CREATE_HIDDEN | CREATE_NO_REMOVE_TEMPLATEPICT;
	int				nOption = CREATE_HIDDEN | CREATE_NO_REMOVE_TEMPLATEPICT | CREATE_ENUM_EXIST_PAGE;
	/// End QA81-14203 RESET_PAGE_NAME_IF_CREATED_FROM_OC
	BOOL bRet1	=	grph.Create(template, nOption);
	string			winName = grph.GetName();
	GraphLayer		lay(winName,0);
	LT_set_str("%Z",winName);
	LT_execute("ii=%Z!templatepict.enable");
	LT_get_var("ii", &isValid);
	if(isValid)
	{
		GraphObject		grPict;
		grPict		=	lay.GraphObjects("TemplatePict");
		string strPath = GetAppPath() + "TemplatePict.bmp";
		BOOL bRet2 	=	grPict.ExtractImageToFile(strPath);
	}
	grph.Destroy();
	return isValid;
}

